/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.RequestManager;
import filenet.ws.listener.axis.rm.SenderWorker;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.axis.MessageContext;

public class WSRequestForward {
    public static int id = 0;
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSRequestForward";
    protected static String SPACE = " ";
    protected static String EOL = "\n";
    static int SENDER_THREADS = 2;
    static String DEFAULT_TARGET_HOST = "localhost";
    static RequestManager m_requestManager = new RequestManager();
    private ArrayList threadList = new ArrayList();
    private boolean running;

    public static String _get_FILE_DATE() {
        return "$Date:   08 Dec 2008 15:32:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public WSRequestForward() {
        this.startSender();
    }

    public void startSender() {
        this.running = true;
        if (m_requestManager == null) {
            m_requestManager = new RequestManager();
        }
        for (int i = 0; i < SENDER_THREADS; ++i) {
            SenderWorker senderWorker = new SenderWorker(m_requestManager);
            senderWorker.setRunning(true);
            this.threadList.add(senderWorker);
            senderWorker.start();
        }
    }

    public void stop() {
        for (SenderWorker sWorker : this.threadList) {
            sWorker.setRunning(false);
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public static RequestManager getRequestManager() {
        return m_requestManager;
    }

    public void addRequest(MessageContext messageContext, int targetPort, String targetHost) {
        m_requestManager.addRequest(messageContext, targetPort, targetHost);
    }

    private void test() {
        System.out.println("Start test");
        try {
            String fileName = "filenet\\ws\\listener\\http\\get";
            for (int i = 0; i < 10; ++i) {
                File file = new File(fileName + i % 3 + ".txt");
                System.out.println("Added req " + i % 3);
                m_requestManager.addRequest(file, (OutputStream)System.out, 8080, null);
            }
            Thread.sleep(10000L);
            this.stop();
        }
        catch (Throwable exp) {
            exp.printStackTrace();
        }
        System.out.println("Stop test");
    }

    public static void main(String[] args) {
        WSRequestForward reqForward = new WSRequestForward();
        reqForward.test();
    }
}

